//******************************************
// file			: SST25V_SPI
// version		: V1.0
// brief		: SST25V related functions
// note			: SST25V related functions are gathered in this subroutine
//******************************************   

//================================================================================
//Function name : SPI_XByte( )
//Description   : Exchange a byte via the SPI bus
//Input         : -Byte, The byte sent
//Output        : The byte returned
//================================================================================
#include "sst25v_spi.h"
#include "MQ6822.h"


void SPI_init()
{
	P7CR.bit.b4 = 0;  //SI
	P7CR.bit.b5 = 1;  //SO
	P7CR.bit.b6 = 1;  //SCLK
	P7CR.bit.b7 = 1;  //CE (SS)
	
	P7FC.bit.b4 = 1;
	P7FC.bit.b5 = 1;
	P7FC.bit.b6 = 1;
	P7FC.bit.b7 = 1;
	__ASM("DI");
	EIRL.bit.b6 = 1;
	POFFCR2.bit.b0 = 1;
	__ASM("EI");
	
}
unsigned char  SST25V_RdStatus()
{
	unsigned char getbyte;
	//===========================================================================Send 0x05(read Status)			,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x05;  //read Status command
	SIO0CR.bit.b2 = 1; //operation start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Receive Status
	SIO0CR.byte = 0xEE^0x80;  //receive mode msb first
    while(SIO0SR.bit.b4==0){WDCDR.byte = 0x4e;} //wait receive end
	SIO0CR.bit.b2 = 0; //operation stop
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
	getbyte = SIO0BUF.byte;
	return getbyte;
}


void  SST25V_WaitBusy()
{   	
	while((SST25V_RdStatus()&0x01)==0x01){}
}




void  SST25V_WaitBusyAAI()
{
	while( SST25V_RdStatus()==0x43 );
}		  




void  SST25V_Init()
{
	//===========================================================================Send 0x50(Write Status Reg Enable)	,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9 ^ 0x80;  //transmit mode msb first
	SIO0BUF.byte = 0x50;  //enable Write status register
	SIO0CR.bit.b2 = 1; //operation start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	SIO0CR.bit.b2 = 0; //operation stop    
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
	
	//===========================================================================Send 0x01(Write Status Reg)	,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
	SIO0BUF.byte = 0x01;  //write Status Reg
	SIO0CR.bit.b2 = 1; //operation start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Send Status Setting
	SIO0BUF.byte = 0x02;  //enable Memory Write
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	SIO0CR.byte = 0xE8^ 0x80;  //forece stop
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			

	//===========================================================================Send 0x80(DBSY)				,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
	SIO0BUF.byte = 0x80;  //Disable SO as RY/BY while AAI Programing
	SIO0CR.bit.b2 = 1; //operatiob start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xE8^ 0x80;  //forece stop
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
}



void  SST25V_ReadJEDECID(unsigned char *ID)
{
	//===========================================================================Send 0x9F(READ JEDEC)			,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x9f;  //read jedec id command
	SIO0CR.bit.b2 = 1; //operation start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end

	//---------------------------------------------------------------------------Receive Manufacture's ID
	SIO0CR.byte = 0xEE^0x80;  //receive mode msb first
    while(SIO0SR.bit.b4==0){WDCDR.byte = 0x4e;} //wait receive end
	ID[0] = SIO0BUF.byte;
	
	//---------------------------------------------------------------------------Receive Memory Type
	while(SIO0SR.bit.b4==0){WDCDR.byte = 0x4e;} //wait receive end
	ID[1] = SIO0BUF.byte;
	
	//---------------------------------------------------------------------------Receive Memory Capacity
	while(SIO0SR.bit.b4==0){WDCDR.byte = 0x4e;} //wait receive end
	SIO0CR.bit.b2 = 0; //operation stop
	ID[2] = SIO0BUF.byte;	
	
	SIO0CR.byte = 0xe8^ 0x80;//force stop
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
}




void  SST25V_EraseBlock32KB(unsigned long int addr)
{
	unsigned char MSB,MID,LSB;	
	MSB = (addr >>16)&0xff;
	MID = (addr >>8)&0xff;
	LSB = (addr )&0xff;
	
	//===========================================================================Send 0x06(Write Enable)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x06;  //Write enable command
	SIO0CR.bit.b2 = 1; //operatiob start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    
	
	//===========================================================================Send 0x52(Erase 32K command)	,Transmit Start  	,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x52;  //Erase 32KB Block Command
	SIO0CR.bit.b2 = 1; //operatiob start    
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end

	//---------------------------------------------------------------------------Send Address [23:16]
	SIO0BUF.byte = MSB;  //Send Address
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [15:8]
	SIO0BUF.byte = MID;  //Send Address
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [7:0]
	SIO0BUF.byte = LSB;  //Send Address
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    	
	
	//===========================================================================Read Status to Check Busy		,Transmit Start    	,SS(P77)=LOW,    
	SST25V_WaitBusy();
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    

}
void SST25V_WriteByte(unsigned long int addr, unsigned char dat)
{
	unsigned int i;
	unsigned char MSB,MID,LSB;	
	MSB = (addr >>16)&0xff;
	MID = (addr >>8)&0xff;
	LSB = (addr )&0xff;

	//===========================================================================Send 0x06(Write Enable)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x06;  //Write enable command
	SIO0CR.bit.b2 = 1; //operation start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    

	//===========================================================================Send 0x02(Program Byte)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x02;  //Program Byte command
	SIO0CR.bit.b2 = 1; //operation start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [23:16]
	SIO0BUF.byte = MSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [15:8]
	SIO0BUF.byte = MID;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [7:0]
	SIO0BUF.byte = LSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Program Data
	SIO0BUF.byte = dat;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    
	
	//===========================================================================Send 0x04(Write Disable)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
	SIO0BUF.byte = 0x04;  //write disable
	SIO0CR.bit.b2 = 1; //operation start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    
	 
	//===========================================================================Read Status to Check Busy		,Transmit Start    	,SS(P77)=LOW,    
	SST25V_WaitBusy();
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    

}


void  SST25V_WriteInc(unsigned long int addr, unsigned char* dat_ptr, unsigned int count)
{	
	unsigned int i;
	unsigned char MSB,MID,LSB;
	
	if(count==0)return; 
	if(count==1)return SST25V_WriteByte(addr,dat_ptr[0]); //length==1,use BYTE PROGRAM
	
	MSB = (addr >>16)&0xff;
	MID = (addr >>8)&0xff;
	LSB = (addr )&0xff;
	
	//===========================================================================Send 0x06(Write Enable)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0x06;  //Write enable command
	SIO0CR.bit.b2 = 1; //operatiob start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    	
	
	//===========================================================================Send 0xAD(AAI Program)			,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
    SIO0BUF.byte = 0xAD;  //AAI COMMAND
	SIO0CR.bit.b2 = 1; //operatiob start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Send Address [23:16]
	SIO0BUF.byte = MSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [15:8]
	SIO0BUF.byte = MID;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [7:0]
	SIO0BUF.byte = LSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end

	//---------------------------------------------------------------------------Send Program Data 1st
	SIO0BUF.byte = *dat_ptr;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Send Program Data 2nd
	SIO0BUF.byte = *(dat_ptr+1);  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end

	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    	
	
	for(i=2;i<count;i+=2)
	{
	//===========================================================================Send 0xAD(AAI Program)			,Transmit Start		,SS(P77)=LOW,    	
		SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
		SIO0BUF.byte = 0xAD;  //AAI COMMAND
		SIO0CR.bit.b2 = 1; //operatiob start  	
		while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
		
	//---------------------------------------------------------------------------Send Program Data i th	
		SIO0BUF.byte = *(dat_ptr+i);  //read jedec id command
		while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Send Program Data i+1th	
		SIO0BUF.byte = *(dat_ptr+i+1);  //read jedec id command
		while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
		
		SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    		
	//===========================================================================Read Status to Check AAI Busy	,Transmit Start    	,SS(P77)=LOW,     
		SST25V_WaitBusyAAI();		
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
	}
	//===========================================================================Send 0x04(Write Disable)		,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first
	SIO0BUF.byte = 0x04;  //write disable
	SIO0CR.bit.b2 = 1; //operatiob start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	SIO0CR.byte = 0xe8^ 0x80; //force stop;
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
	
	SST25V_WaitBusyAAI();
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
	 
	 
	if((count%2)==1)SST25V_WriteByte(addr+count-1,dat_ptr[count-1]); //deal with ODD number
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
}




void  SST25V_ReadInc(unsigned long int addr, unsigned char* dat_ptr,unsigned int count)
{
	unsigned int i;
	unsigned char MSB,MID,LSB;	
	
	if(count==0)return;
	
	MSB = (addr >>16)&0xff;
	MID = (addr >>8)&0xff;
	LSB = (addr )&0xff;
	
	//===========================================================================Send 0x03(Read)				,Transmit Start		,SS(P77)=LOW,    
	SIO0CR.byte = 0xE9^ 0x80;  //transmit mode msb first	
	SIO0BUF.byte = 0x03;  //READ COMMAND
	SIO0CR.bit.b2 = 1; //operatiob start  	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end

	//---------------------------------------------------------------------------Send Address [23:16]
	SIO0BUF.byte = MSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [15:8]
	SIO0BUF.byte = MID;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end	
	
	//---------------------------------------------------------------------------Send Address [7:0]
	SIO0BUF.byte = LSB;  //read jedec id command
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait SHIFT end
	
	//---------------------------------------------------------------------------Receive Data 1th,2nd,.....Nth
	SIO0CR.byte = 0xEE^ 0x80;  //receive mode msb first    
	i=0;
	for(;i<count-1;i++)
	{
		while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait receive end
		dat_ptr[i] = SIO0BUF.byte;		
	}
	
	while(SIO0SR.bit.b6==1){WDCDR.byte = 0x4e;} //wait receive end
	SIO0CR.bit.b2 = 0; //operation stop
	dat_ptr[i] = SIO0BUF.byte;
	
	SIO0CR.byte = 0xE8^ 0x80;  //force stop
	//===========================================================================								,Transmit End,    	,SS(P77)=HIGH,    			
}

